<?php
  session_start();
  include 'komunikaty.php';

  function addToDBTable($baza, $tabela, $kolumny, $wartosci){
    //Parametry połączenia
    $dsn = "mysql:host=localhost;dbname=$baza";
    $uzytkownik = "php";
    $haslo = "test";

    $dbo = new PDO($dsn, $uzytkownik, $haslo);
    
    //Zabezpieczenie danych
    foreach ($wartosci as $key => $val){
      $wartosci[$key] = $dbo->quote($val);
    }
    
    //Utworzenie zapytania.
    $query = "INSERT INTO `$tabela` (`". implode("`, `", $kolumny) ."`)";
    $query .= " VALUES(" . implode(", ", $wartosci) . ")";

    if(($rowsNo = $dbo->exec($query)) === false){
      //Wystąpił błąd przy wykonywaniu zapytania.
      throw new PDOException("Treść zapytania: $query");
    }

    $dbo = null;

    addMessage("Zapytanie zostało wykonane.<br>" .
               "Liczba dodanych rekordów: $rowsNo");
  }

  //Odczytanie parametrów i wywołanie funkcji dodającej dane
  if(isset($_POST['nazwa']) && 
     isset($_POST['id']) && $_POST['nazwa'] != ''){
    $id = strval(intval($_POST['id']));
    $nazwa = $_POST['nazwa'];
    try{
      addToDBTable(
        'ksiegarnia',
        'Autorzy',
        array('Id', 'Nazwa'),
        array($id, $nazwa)
      );
    }
    catch(Exception $e){
      addMessage('Wystąpił błąd. Szczegóły: ' . $e);
    }
  }
  else{
    addMessage('Niepoprawne dane!');
  }

  header('Location:wynik.php');
?>
